<!DOCTYPE html>
<html>
<head> 
    <meta charset="utf-8"> 
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"> 
    <title>Team 2 Member</title> 

    <!-- Stylesheets -->
    <link rel="stylesheet" href="/mbtech/layui.css"> 
    <link rel="stylesheet" href="/mbtech/common.css"> 
    <link rel="stylesheet" href="/mbtech/swiper-bundle.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/css/layui.min.css">

    <style>
        .team_card {
            margin-top: 25px;
            background-color: #FFFFFF;
            height: auto;
            padding: 0 17px;
            border-radius: 20px;
        }
        .label {
            font-family: Arial, Arial;
            font-weight: 400;
            font-size: 14px;
            color: #95FCBE;
            line-height: 22px;
        }
        .value {
            font-family: Arial, Arial;
            font-weight: 700;
            font-size: 24px;
            color: #FFFB00;
            line-height: 28px;
        }
        .text-success {
            color: #28a745; /* green */
        }
        .text-danger {
            color: #dc3545; /* red */
        }
    </style> 
</head> 
<body class="common_body"> 

    <!-- Header -->
    <div class="common_header common_header_order" style="height: 150px;"> 
        <a href="javascript:history.back(-1)" class="back position"> 
            <p class="btn"><i class="layui-icon layui-icon-left layui-font-20"></i></p> 
            Team 1 Member 
        </a> 
        <!--a href="/help" style="position:absolute;top:15px; right:15px;height: 36px;width: 36px;background: #20C57A;border-radius: 12px;border: 1px solid #7DD8A2;"> 
            <img src="/public/site/img/common/service.png" style="height:22px;width: 22px;padding-top: 8px;padding-left: 8px "> 
        </a> -->
        <div style="padding: 10px 20px;"> 
            <p class="label">Referral (Valid/Total)：</p> 
            <p class="value">{{$third_level_users->where('investor', 1)->count()}} / {{ count($third_level_users) }}</p> 
        </div> 
    </div> 

    <!-- Main Team Content -->
    <div class="team_main" style="position: relative;top: -90px"> 
        <div class="team_card"> 
            <p class="title" style="padding-top: 15px">Team 1 Member</p>

            @foreach ($third_level_users as $user)
            <div class="right"> 
                <div class="item flex_space" style="border-bottom: 1px solid #F3F3F3;padding-bottom: 10px;"> 
                    <div class="label"> 
                        <p style="color: #0F7A5A">{{ substr($user->phone, 0, 2) }}******{{ substr($user->phone, -2) }}</p> 
                        <p style="color: #0F7A5A">{{ $user->created_at }}</p> 
                    </div> 
                    <p class="value"> 
                        <span class="{{ $user->is_active == 'Active' ? 'text-success' : 'text-danger' }}">
                            {{ $user->is_active }}
                        </span>
                    </p> 
                </div> 
            </div>
            @endforeach

        </div> 
    </div> 

    <!-- Floating Help Button -->
    <a href="/help" target="_blank" id="service"> 
        <img src="/public/site/img/common/service.png" style="width: 40px;height: 40px"> 
    </a> 

    <!-- JS -->
    <script>
        layui.use(function(){
            var $ = layui.jquery;
            var layer = layui.layer;
            var form = layui.form;
            var laydate = layui.laydate;
            var slider = layui.slider;
            var element = layui.element;
            var swiper = new Swiper(".mySwiper", {
                slidesPerView: "auto",
                centeredSlides: true,
                initialSlide: 1,
                spaceBetween: 30,
                pagination: {
                    el: ".swiper-pagination",
                    clickable: true,
                },
                dynamicBullets: true,
                on: {
                    slideChangeTransitionStart: function(){
                        var level = this.activeIndex;
                        $('.team_contents').removeClass('layui-show').addClass('layui-hide');
                        $('.team_' + level).removeClass('layui-hide').addClass('layui-show');
                    },
                }
            });
        });
    </script> 
</body>
</html>
